/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import org.json.JSONArray;

public class GXNavigationHelper
implements Serializable {
    private static final long serialVersionUID = 2608956804836620190L;
    private static final ILogger logger = LogManager.getLogger(GXNavigationHelper.class);
    public static String POPUP_LEVEL = "gxPopupLevel";
    public static String TAB_ID = "gxTabId";
    public static String TAB_ID_HEADER = "X-Gx-Tabid";
    public static String CALLED_AS_POPUP = "gxCalledAsPopup";
    private Hashtable<String, Stack<String>> referers = new Hashtable();

    public String toJSonString(String lvl) {
        JSONArray array = new JSONArray();
        if (this.referers.containsKey(lvl)) {
            Stack<String> levelStack = this.referers.get(lvl);
            for (int i = 0; i < levelStack.size(); ++i) {
                array.put(levelStack.get(i));
            }
        }
        return array.toString();
    }

    public void pushUrl(String url) {
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return;
        }
        String popupLevel = GXNavigationHelper.getUrlPopupLevel(url);
        if (!this.referers.containsKey(popupLevel)) {
            Stack<String> stack = new Stack<String>();
            stack.push(url);
            this.referers.put(popupLevel, stack);
        } else {
            Stack<String> stack = this.referers.get(popupLevel);
            stack.push(url);
        }
    }

    public void popUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return;
        }
        String popupLevel = GXNavigationHelper.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 0) {
            stack.pop();
        }
    }

    public String peekUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return "";
        }
        String popupLevel = GXNavigationHelper.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 0) {
            return stack.peek();
        }
        return "";
    }

    public String getRefererUrl(String url) {
        Stack<String> stack;
        if (url.indexOf(CALLED_AS_POPUP) != -1) {
            return "";
        }
        String popupLevel = GXNavigationHelper.getUrlPopupLevel(url);
        if (this.referers.containsKey(popupLevel) && (stack = this.referers.get(popupLevel)).size() > 1) {
            String topUrl = stack.pop();
            String referer = stack.peek();
            stack.push(topUrl);
            return referer;
        }
        return "";
    }

    public int count() {
        return this.referers.size();
    }

    public void deleteStack(String popupLevel) {
        if (this.referers.containsKey(popupLevel)) {
            this.referers.remove(popupLevel);
        }
    }

    public static String getUrlComponent(String url, String key) {
        int cIdx;
        int eqIdx;
        int pIdx;
        url = SpecificImplementation.GXutil.URLDecode(url);
        String result = "";
        if (url != null && (pIdx = url.indexOf(key)) != -1 && (eqIdx = url.indexOf("=", pIdx)) != -1 && (cIdx = url.indexOf(";", eqIdx)) > eqIdx) {
            try {
                result = url.substring(eqIdx + 1, cIdx);
            }
            catch (IndexOutOfBoundsException e) {
                logger.error(String.format("Searching parm:'%1$s' in url:'%2$s'", key, url), e);
            }
        }
        return result;
    }

    public static String getUrlPopupLevel(String url) {
        String result = GXNavigationHelper.getUrlComponent(url, POPUP_LEVEL);
        return result.isEmpty() ? "-1" : result;
    }
}

