/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.SSLManager;
import HTTPClient.URI;
import com.genexus.CommonUtil;
import com.genexus.internet.GXHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpClientManual
extends GXHttpClient {
    private HTTPConnection con = null;
    private HTTPResponse res;

    private void resetErrors() {
        this.setErrCode(0);
        this.setErrDescription("");
    }

    private String getURLValid(String url) {
        try {
            URI uri = new URI(url);
            this.setPrevURLhost(this.getHost());
            this.setPrevURLbaseURL(this.getBaseURL());
            this.setPrevURLport(this.getPort());
            this.setPrevURLsecure(this.getSecure());
            this.setIsURL(true);
            this.setURL(url);
            StringBuilder relativeUri = new StringBuilder();
            if (uri.getPath() != null) {
                relativeUri.append(uri.getPath());
            }
            if (uri.getQueryString() != null) {
                relativeUri.append('?').append(uri.getQueryString());
            }
            if (uri.getFragment() != null) {
                relativeUri.append('#').append(uri.getFragment());
            }
            return relativeUri.toString();
        }
        catch (ParseException e) {
            return url;
        }
    }

    private NVPair[] hashtableToNVPair(Hashtable hashtable) {
        NVPair[] ret = new NVPair[hashtable.size()];
        int idx = 0;
        Enumeration en = hashtable.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            ret[idx++] = new NVPair((String)key, (String)hashtable.get(key));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String method, String url) {
        this.resetErrors();
        url = this.getURLValid(url);
        try {
            GXHttpClient.HttpClientPrincipal p;
            Enumeration<GXHttpClient.HttpClientPrincipal> en;
            if (this.getHostChanged()) {
                if (this.con != null) {
                    this.con.stop();
                }
                if (this.getSecure() == 1 && this.getPort() == 80) {
                    this.setPort(443);
                }
                this.con = new HTTPConnection(this.getSecure() == 0 ? "http" : "https", this.getHost(), this.getPort());
                if (this.getSecure() != 0) {
                    this.con.setSSLConnection(SSLManager.getSSLConnection());
                }
                this.con.setTcpNoDelay(this.getTcpNoDelay());
                this.con.setIncludeCookies(this.getIncludeCookies());
            }
            this.con.setTimeout(this.getTimeout() * 1000);
            if (this.getProxyInfoChanged()) {
                this.con.setCurrentProxy(this.getProxyServerHost(), this.getProxyServerPort());
            }
            if (this.getHostChanged() || this.getAuthorizationChanged()) {
                en = this.getBasicAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                    this.con.addBasicAuthorization(p.realm, p.user, p.password);
                }
                en = this.getDigestAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                    this.con.addDigestAuthorization(p.realm, p.user, p.password);
                }
                en = this.getNTLMAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                }
            }
            this.setHostChanged(false);
            this.setAuthorizationChanged(false);
            if (this.getProxyInfoChanged() || this.getAuthorizationProxyChanged()) {
                en = this.getBasicProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                    this.con.addBasicProxyAuthorization(p.realm, p.user, p.password);
                }
                en = this.getDigestProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                    this.con.addDigestProxyAuthorization(p.realm, p.user, p.password);
                }
                en = this.getNTLMProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    GXHttpClient.HttpClientPrincipal httpClientPrincipal = en.nextElement();
                }
            }
            this.setProxyInfoChanged(false);
            this.setAuthorizationProxyChanged(false);
            url = this.setPathUrl(url);
            this.res = method.equalsIgnoreCase("GET") ? (this.getContentToSend().size() > 0 ? this.con.Get(url, "", this.hashtableToNVPair(this.getheadersToSend()), this.getData()) : this.con.Get(url, "", this.hashtableToNVPair(this.getheadersToSend()))) : (method.equalsIgnoreCase("POST") ? (!this.getIsMultipart() && this.getVariablesToSend().size() > 0 ? this.con.Post(url, this.hashtableToNVPair(this.getVariablesToSend()), this.hashtableToNVPair(this.getheadersToSend())) : this.con.Post(url, this.getData(), this.hashtableToNVPair(this.getheadersToSend()))) : (method.equalsIgnoreCase("PUT") ? this.con.Put(url, this.getData(), this.hashtableToNVPair(this.getheadersToSend())) : (method.equalsIgnoreCase("DELETE") ? (this.getVariablesToSend().size() > 0 || this.getContentToSend().size() > 0 ? this.con.Delete(url, this.getData(), this.hashtableToNVPair(this.getheadersToSend())) : this.con.Delete(url, this.hashtableToNVPair(this.getheadersToSend()))) : this.con.ExtensionMethod(method, url, this.getData(), this.hashtableToNVPair(this.getheadersToSend())))));
        }
        catch (ProtocolNotSuppException e) {
            System.err.println(e);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
        finally {
            this.getStatusCode();
            if (this.getIsURL()) {
                this.setHost(this.getPrevURLhost());
                this.setBaseURL(this.getPrevURLbaseURL());
                this.setPort(this.getPrevURLport());
                this.setSecure(this.getPrevURLsecure());
                this.setIsURL(false);
            }
        }
        this.resetState();
    }

    @Override
    public int getStatusCode() {
        if (this.res == null) {
            return 0;
        }
        try {
            return this.res.getStatusCode();
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
            this.res = null;
        }
        catch (ModuleException e) {
            this.setExceptionsCatch(e);
        }
        catch (Exception e) {
            this.probableProxyError(e);
        }
        return 0;
    }

    @Override
    public String getReasonLine() {
        if (this.res == null) {
            return "";
        }
        try {
            return this.res.getReasonLine();
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
            return "";
        }
        catch (Exception e) {
            this.probableProxyError(e);
            return "";
        }
    }

    private void probableProxyError(Exception e) {
        this.setErrCode(1);
        try {
            this.setErrDescription(e.getMessage().endsWith("because \"resp\" is null") ? "Possible fail reason: Proxy unavailable. Real error message: " + e.getMessage() : e.getMessage());
        }
        catch (NullPointerException getmsgException) {
            this.setErrDescription("Unknown error");
        }
    }

    @Override
    public void getHeader(String name, long[] value) {
        if (this.res == null) {
            return;
        }
        try {
            value[0] = this.res.getHeaderAsInt(name);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    @Override
    public String getHeader(String name) {
        if (this.res == null) {
            return "";
        }
        try {
            return this.res.getHeader(name);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
            return "";
        }
    }

    @Override
    public void getHeader(String name, String[] value) {
        if (this.res == null) {
            return;
        }
        try {
            value[0] = this.res.getHeader(name);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    @Override
    public void getHeader(String name, Date[] value) {
        if (this.res == null) {
            return;
        }
        try {
            value[0] = this.res.getHeaderAsDate(name);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    @Override
    public void getHeader(String name, double[] value) {
        if (this.res == null) {
            return;
        }
        try {
            value[0] = CommonUtil.val(this.res.getHeader(name));
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return this.res.getInputStream();
        }
        catch (ModuleException e) {
            throw new IOException("Module/ " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Module/ " + e.getMessage());
        }
    }

    private static InputStream getInputStreamStaticMethod(String stringURL) throws IOException {
        try {
            URI url = new URI(stringURL);
            return new HTTPConnection(url.getScheme(), url.getHost(), url.getPort()).Get(url.getPathAndQuery()).getInputStream();
        }
        catch (ParseException e) {
            throw new IOException("Malformed URL " + e.getMessage());
        }
        catch (ModuleException e) {
            throw new IOException("ModuleException " + e.getMessage());
        }
    }

    @Override
    public String getString() {
        if (this.res == null) {
            return "";
        }
        try {
            return this.res.getText();
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
        catch (Exception e) {
            this.setExceptionsCatch(e);
        }
        return "";
    }

    @Override
    public boolean getEof() {
        return true;
    }

    @Override
    public String readChunk() {
        return this.getString();
    }

    @Override
    public void toFile(String fileName) {
        if (this.res == null) {
            return;
        }
        try {
            CommonUtil.InputStreamToFile(this.res.getInputStream(), fileName);
        }
        catch (ModuleException | IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.con != null) {
            this.con.stop();
        }
    }

    static {
        String os;
        HTTPConnection.setDefaultAllowUserInteraction(false);
        if (CommonUtil.isWindows() && ((os = System.getProperty("os.name", "").trim().toUpperCase()).endsWith("95") || os.endsWith("98") || os.endsWith("ME"))) {
            HTTPConnection.setPipelining(false);
        }
    }
}

