/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.json;

import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.json.JSONTokenerWrapper;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONObjectWrapper
extends JSONObject
implements Serializable {
    private Map<String, Object> map;

    public JSONObjectWrapper() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
    }

    public JSONObjectWrapper(String string) {
        super((JSONTokener)(SpecificImplementation.JsonSerialization != null ? SpecificImplementation.JsonSerialization.getJSONTokener(string) : new JSONTokenerWrapper(string)));
        this.initMap();
    }

    public JSONObjectWrapper(JSONTokenerWrapper token) {
        super((JSONTokener)token);
        this.initMap();
    }

    public JSONObjectWrapper(Map<?, ?> m) {
        super(m);
        this.map = new LinkedHashMap<String, Object>(m.size());
        for (Map.Entry<?, ?> e : m.entrySet()) {
            if (e.getKey() == null) {
                throw new NullPointerException("Null key.");
            }
            Object value = e.getValue();
            if (value == null) continue;
            this.map.put(String.valueOf(e.getKey()), value);
        }
    }

    public JSONObjectWrapper(JSONObject jsonObject) {
        super(jsonObject.toString());
        this.initMap();
    }

    private void initMap() {
        if (this.map == null) {
            this.map = SpecificImplementation.JsonSerialization != null ? SpecificImplementation.JsonSerialization.getJSONObjectMap(this) : new LinkedHashMap<String, Object>();
        }
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public void clear() {
        super.clear();
        this.map.clear();
    }

    public JSONObjectWrapper put(String key, Object value) throws JSONException {
        if (value == null) {
            super.put(key, JSONObject.NULL);
        } else {
            super.put(key, value);
        }
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
        if (this.map.containsKey(key)) {
            this.map.replace(key, value);
        } else {
            this.map.put(key, value);
        }
        return this;
    }

    public Object remove(String key) {
        if (this.map.containsKey(key)) {
            this.map.remove(key);
        }
        return super.remove(key);
    }
}

