/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.util.GXDirectoryCollection;
import com.genexus.util.GXFileCollection;
import com.genexus.util.GXFileInfo;
import com.genexus.util.IGXFileInfo;
import java.io.File;

public class GXDirectory {
    private IGXFileInfo DirSource;
    private int ErrCode;
    private String ErrDescription;
    private boolean ret;

    public GXDirectory() {
    }

    public GXDirectory(String DirName) {
        this.DirSource = new GXFileInfo(new File(DirName), true);
    }

    public GXDirectory(IGXFileInfo Dir) {
        this.DirSource = Dir;
    }

    public void setDirectoryInfo(IGXFileInfo dirInfo) {
        this.DirSource = dirInfo;
    }

    public void setSource(String DirName) {
        this.DirSource = new GXFileInfo(new File(DirName), true);
    }

    public String getSource() {
        if (this.DirSource == null) {
            return "";
        }
        return this.DirSource.getPath();
    }

    public void create() {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (this.DirSource.isDirectory() && this.DirSource.exists()) {
                this.ErrCode = 3;
                this.ErrDescription = "Directory already exists";
            } else {
                try {
                    this.ret = this.DirSource.mkdir();
                    if (!this.ret) {
                        this.setUnknownError();
                    }
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
            }
        }
    }

    public void delete() {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (!this.DirSource.isDirectory() && !this.DirSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "The directory couldn't be deleted; directory does not exist";
            } else if (this.DirSource.list().length != 0) {
                this.ErrCode = 4;
                this.ErrDescription = "The directory couldn't be deleted, directory not empty";
            } else {
                try {
                    this.ret = this.DirSource.delete();
                    if (!this.ret) {
                        this.setUnknownError();
                    }
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
            }
        }
    }

    public boolean exists() {
        if (this.sourceSeted()) {
            try {
                this.resetErrors();
                return this.DirSource.exists();
            }
            catch (SecurityException e) {
                this.ErrCode = 100;
                this.ErrDescription = e.getMessage();
                return false;
            }
        }
        return false;
    }

    public void rename(String FileName) {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (!this.DirSource.isDirectory() && !this.DirSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "The directory couldn't be renamed; directory does not exist";
            } else if (new File(FileName).exists()) {
                this.ErrCode = 3;
                this.ErrDescription = "Directory already exists";
            } else {
                try {
                    this.ret = this.DirSource.renameTo(FileName);
                    if (!this.ret) {
                        this.setUnknownError();
                    }
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
            }
        }
    }

    public String getName() {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (!this.DirSource.isDirectory() && !this.DirSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "Directory does not exist";
                return "";
            }
            return this.DirSource.getName();
        }
        return "";
    }

    public String getAbsoluteName() {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (!this.DirSource.isDirectory() && !this.DirSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "Directory does not exist";
                return "";
            }
            try {
                return this.DirSource.getAbsolutePath();
            }
            catch (SecurityException e) {
                this.ErrCode = 100;
                this.ErrDescription = e.getMessage();
                return "";
            }
        }
        return "";
    }

    public GXFileCollection getFiles() {
        return this.getFiles("");
    }

    public GXFileCollection getFiles(String strFilter) {
        if (this.sourceSeted()) {
            this.resetErrors();
            GXFileCollection gxfiles = this.DirSource.listFiles(strFilter);
            if (gxfiles == null) {
                this.ErrCode = 2;
                this.ErrDescription = "Directory does not exist";
            }
            return gxfiles;
        }
        return new GXFileCollection();
    }

    public GXDirectoryCollection getDirectories() {
        if (this.sourceSeted()) {
            this.resetErrors();
            GXDirectoryCollection DirCollection = this.DirSource.listDirectories();
            if (DirCollection == null) {
                this.ErrCode = 2;
                this.ErrDescription = "Directory does not exist";
            }
            return DirCollection;
        }
        return new GXDirectoryCollection();
    }

    public int getErrCode() {
        return this.ErrCode;
    }

    public String getErrDescription() {
        return this.ErrDescription;
    }

    private void resetErrors() {
        this.ErrCode = 0;
        this.ErrDescription = "";
    }

    private boolean sourceSeted() {
        if (this.DirSource == null) {
            this.ErrCode = 1;
            this.ErrDescription = "Invalid Directory instance";
            return false;
        }
        return true;
    }

    private void setUnknownError() {
        this.ErrCode = -1;
        this.ErrDescription = "Unknown error";
    }

    public static String applicationdatapath() {
        return SpecificImplementation.GXDirectory.getApplicationDataPath();
    }

    public static String temporaryfilespath() {
        return SpecificImplementation.GXDirectory.getTemporaryFilesPath();
    }

    public static String externalfilespath() {
        return SpecificImplementation.GXDirectory.getExternalFilesPath();
    }

    public static String cachefilespath() {
        return SpecificImplementation.GXDirectory.getCacheFilesPath();
    }
}

