/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.ClientContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GXGeolocation {
    private static double getComponent(String geolocation, int item) {
        StringTokenizer st = new StringTokenizer(geolocation, ",");
        if (st.countTokens() == 2) {
            String token = null;
            for (int currentToken = 0; currentToken <= item; ++currentToken) {
                token = st.nextToken();
            }
            return Double.parseDouble(token);
        }
        return 0.0;
    }

    public static double getLatitude(String geolocation) {
        return GXGeolocation.getComponent(geolocation, 0);
    }

    public static double getLongitude(String geolocation) {
        return GXGeolocation.getComponent(geolocation, 1);
    }

    private static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static int getDistance(String location1, String location2) {
        double lat1 = GXGeolocation.getLatitude(location1);
        double lon1 = GXGeolocation.getLongitude(location1);
        double lat2 = GXGeolocation.getLatitude(location2);
        double lon2 = GXGeolocation.getLongitude(location2);
        double d_lat = GXGeolocation.degreesToRadians(lat2 - lat1);
        double d_lon = GXGeolocation.degreesToRadians(lon2 - lon1);
        lat1 = GXGeolocation.degreesToRadians(lat1);
        lat2 = GXGeolocation.degreesToRadians(lat2);
        double a1 = Math.pow(Math.sin(d_lat / 2.0), 2.0);
        double a2 = Math.pow(Math.sin(d_lon / 2.0), 2.0);
        double a3 = Math.cos(lat1) * Math.cos(lat2);
        double a = a1 + a2 * a3;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c * 1000.0;
        return (int)distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromURL(String urlString) {
        HttpURLConnection connection = null;
        BufferedReader rd = null;
        StringBuffer sb = null;
        String line = null;
        String result = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.connect();
            rd = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
            sb = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            result = sb.toString();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (ProtocolException protocolException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
            rd = null;
            sb = null;
        }
        return result;
    }

    public static String getAPIKey() {
        return ClientContext.getModelContext().getClientPreferences().getGOOGLE_API_KEY();
    }

    public static Vector<String> getAddress(String location) {
        String urlString = "https://maps.google.com/maps/api/geocode/json?latlng=" + location.trim() + "&sensor=false";
        String apiKey = GXGeolocation.getAPIKey();
        if (apiKey.length() > 0) {
            urlString = urlString + urlString + "&key=" + apiKey;
        }
        urlString = urlString.replace(" ", "+");
        String response = GXGeolocation.getContentFromURL(urlString);
        Vector<String> result = new Vector<String>();
        if (response != null) {
            try {
                JSONObject json = new JSONObject(response);
                if (json.has("results")) {
                    JSONArray results = json.optJSONArray("results");
                    for (int i = 0; i < results.length(); ++i) {
                        JSONObject jo = results.optJSONObject(i);
                        if (!jo.has("formatted_address")) continue;
                        result.add(jo.optString("formatted_address"));
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Vector<String> getLocation(String address) {
        Vector<String> result = new Vector<String>();
        if (address == null || address.isEmpty()) {
            return result;
        }
        try {
            String response;
            JSONObject json;
            String urlString = "https://maps.google.com/maps/api/geocode/json?address=" + URLEncoder.encode(address, "utf-8") + "&sensor=false";
            String apiKey = GXGeolocation.getAPIKey();
            if (apiKey.length() > 0) {
                urlString = urlString + urlString + "&key=" + apiKey;
            }
            if ((json = new JSONObject(response = GXGeolocation.getContentFromURL(urlString))).has("results")) {
                JSONArray results = json.optJSONArray("results");
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject location;
                    JSONObject geometry;
                    JSONObject jo = results.optJSONObject(i);
                    if (!jo.has("geometry") || !(geometry = jo.optJSONObject("geometry")).has("location") || !(location = geometry.optJSONObject("location")).has("lat") || !location.has("lng")) continue;
                    String geoloc = location.optString("lat") + "," + location.optString("lng");
                    result.add(geoloc);
                }
            } else if (json.has("error_message")) {
                String error_message = json.optString("error_message");
                return result;
            }
        }
        catch (JSONException jSONException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

