/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CommonUtil;
import com.genexus.GXBaseCollection;
import com.genexus.SdtMessages_Message;
import com.genexus.internet.IGxJSONSerializable;
import com.genexus.json.JSONObjectWrapper;
import com.genexus.util.GXProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;

public class GXProperties
implements IGxJSONSerializable {
    private LinkedHashMap<String, GXProperty> properties = new LinkedHashMap();
    private boolean eof;
    private int lastElement;

    public void set(String name, String value) {
        this.put(name, value);
    }

    public void add(String name, String value) {
        this.put(name, value);
    }

    public void put(String name, String value) {
        String lowerName = name.toLowerCase();
        this.properties.put(lowerName, new GXProperty(name, value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GXProperty property : this.properties.values()) {
            builder.append(property.getValue());
        }
        return builder.toString();
    }

    public String get(String name) {
        return this.containsKey(name = name.toLowerCase()) ? this.properties.get(name).getValue() : "";
    }

    public void remove(String name) {
        name = name.toLowerCase();
        this.properties.remove(name);
    }

    public boolean containsKey(String name) {
        name = name.toLowerCase();
        return this.properties.containsKey(name);
    }

    public GXProperty item(int i) {
        int counter = 0;
        for (Map.Entry<String, GXProperty> entry : this.properties.entrySet()) {
            if (counter++ != i) continue;
            return entry.getValue();
        }
        throw new IndexOutOfBoundsException("The provided index is larger than the amount of items stored");
    }

    public int getCount() {
        return this.count();
    }

    public int count() {
        return this.properties.size();
    }

    public void clear() {
        this.properties.clear();
    }

    public GXProperty first() {
        this.eof = false;
        if (this.count() > 0) {
            this.lastElement = 0;
            return this.properties.entrySet().iterator().next().getValue();
        }
        this.eof = true;
        return null;
    }

    public boolean eof() {
        return this.eof;
    }

    public GXProperty next() {
        ++this.lastElement;
        if (this.count() > this.lastElement) {
            return this.item(this.lastElement);
        }
        this.eof = true;
        return null;
    }

    @Override
    public Object GetJSONObject() {
        JSONObjectWrapper jObj = new JSONObjectWrapper();
        for (int i = 0; this.count() > i; ++i) {
            GXProperty prop = this.item(i);
            try {
                jObj.put(prop.getKey(), prop.getValue());
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jObj;
    }

    @Override
    public String toJSonString() {
        JSONObjectWrapper jObj = (JSONObjectWrapper)this.GetJSONObject();
        return jObj.toString();
    }

    @Override
    public boolean fromJSonString(String s) {
        return this.fromJSonString(s, null);
    }

    @Override
    public boolean fromJSonString(String s, GXBaseCollection<SdtMessages_Message> messages) {
        this.clear();
        if (!s.isEmpty()) {
            try {
                JSONObjectWrapper jObj = new JSONObjectWrapper(s);
                for (Map.Entry<String, Object> e : jObj.entrySet()) {
                    String key = e.getKey();
                    this.put(key, jObj.get(key).toString());
                }
                return true;
            }
            catch (JSONException ex) {
                CommonUtil.ErrorToMessages("fromjson error", ex.getMessage(), messages);
                return false;
            }
        }
        CommonUtil.ErrorToMessages("fromjson error", "empty string", messages);
        return false;
    }
}

