/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;

public class HexUtil {
    private HexUtil() {
    }

    public static final String bytesToHex(byte[] bs, int off, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        HexUtil.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static final void bytesToHexAppend(byte[] bs, int off, int length, StringBuffer sb) {
        sb.ensureCapacity(sb.length() + length * 2);
        for (int i = off; i < off + length && i < bs.length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static final String bytesToHex(byte[] bs) {
        return HexUtil.bytesToHex(bs, 0, bs.length);
    }

    public static final byte[] hexToBytes(String s) {
        return HexUtil.hexToBytes(s, 0);
    }

    public static final byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    public static final void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if (slen % 2 != 0) {
            s = '0' + s;
        }
        if (out.length < off + slen / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + "<" + off + slen / 2 + ")");
        }
        for (int i = 0; i < slen; i += 2) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
        }
    }

    public static final byte[] bitsToBytes(BitSet ba, int size) {
        int bytesAlloc = HexUtil.countBytesForBits(size);
        byte[] b = new byte[bytesAlloc];
        StringBuffer sb = null;
        for (int i = 0; i < b.length; ++i) {
            int s = 0;
            for (int j = 0; j < 8; ++j) {
                int idx = i * 8 + j;
                boolean val = idx > size ? false : ba.get(idx);
                s = (short)(s | (val ? 1 << j : 0));
                if (sb == null) continue;
                sb.append(val ? (char)'1' : '0');
            }
            if (s > 255) {
                throw new IllegalStateException("WTF? s = " + s);
            }
            b[i] = (byte)s;
        }
        return b;
    }

    public static final String bitsToHexString(BitSet ba, int size) {
        return HexUtil.bytesToHex(HexUtil.bitsToBytes(ba, size));
    }

    public static int countBytesForBits(int size) {
        return size / 8 + (size % 8 == 0 ? 0 : 1);
    }

    public static void writeBigInteger(BigInteger integer, DataOutputStream out) throws IOException {
        if (integer.signum() == -1) {
            throw new IllegalStateException("Negative BigInteger!");
        }
        byte[] buf = integer.toByteArray();
        if (buf.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Too long: " + buf.length);
        }
        out.writeShort((short)buf.length);
        out.write(buf);
    }

    public static BigInteger readBigInteger(DataInputStream dis) throws IOException {
        short i = dis.readShort();
        if (i < 0) {
            throw new IOException("Invalid BigInteger length: " + i);
        }
        byte[] buf = new byte[i];
        dis.readFully(buf);
        return new BigInteger(1, buf);
    }

    public static String biToHex(BigInteger bi) {
        return HexUtil.bytesToHex(bi.toByteArray());
    }

    public static boolean InHexFormat(String hexString) {
        for (int i = 0; i < hexString.length(); ++i) {
            if (HexUtil.IsHexDigit(hexString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean IsHexDigit(char c) {
        int numA = Character.digit('A', 32);
        int num1 = Character.digit('0', 32);
        int numChar = Character.digit(c = new String(new char[]{c}).toUpperCase().charAt(0), 32);
        if (numChar >= numA && numChar < numA + 6) {
            return true;
        }
        return numChar >= num1 && numChar < num1 + 10;
    }
}

