/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.ResourceReader;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.json.JSONObjectWrapper;
import com.genexus.util.Encryption;
import com.genexus.util.EnvVarReader;
import com.genexus.util.GXFileInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class IniFile {
    public static final ILogger logger = LogManager.getLogger(IniFile.class);
    private static final int SECTION = 1;
    private static final int PROPERTY = 2;
    private static final int COMMENT = 3;
    private static final int IGNORE = 4;
    private File fileHandle;
    private Hashtable sections = new Hashtable();
    private BufferedReader br;
    private static final int RELOAD_INT = 5000;
    private boolean isAutomaticReloading = false;
    private long lastReloadTime = 0L;
    private String defaultSiteKey = "7E2E22D26FF2989E2444852A85E57867";
    private String defaultServerKey = "7E2E22D26FF2989E2444852A85E57867";
    private String siteKey;
    private String serverKey;
    private static ConcurrentHashMap<String, String> s_confMapping;
    private static String CONFMAPPING_FILE;
    private InputStream encryptionIs;
    private Object lock = new Object();

    public IniFile(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("Null inputStream");
        }
        this.br = new BufferedReader(new InputStreamReader(in));
        this.read();
    }

    public IniFile(String filename) {
        try {
            this.fileHandle = new File(filename);
            this.br = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileHandle)));
            this.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEncryptionStream(InputStream is) {
        this.encryptionIs = is;
        this.ensureServerKey();
        this.ensureSiteKey();
    }

    public String getServerKey() {
        if (this.serverKey != null) {
            return this.serverKey;
        }
        this.ensureServerKey();
        return this.serverKey;
    }

    private void ensureServerKey() {
        this.serverKey = this.getFromKeyFile(0);
        if (this.serverKey != null) {
            return;
        }
        if (this.encryptionIs == null) {
            this.serverKey = this.defaultServerKey;
            return;
        }
        try {
            IniFile crypto = new IniFile(this.encryptionIs);
            this.serverKey = crypto.getProperty("Encryption", "ServerKey", null);
        }
        catch (Exception e) {
            logger.debug("Could not read ServerKey from InputStream", e);
        }
        this.serverKey = this.serverKey == null ? this.defaultServerKey : this.serverKey;
    }

    public String getSiteKey() {
        if (this.siteKey != null) {
            return this.siteKey;
        }
        this.ensureSiteKey();
        return this.siteKey;
    }

    private void ensureSiteKey() {
        this.siteKey = this.getFromKeyFile(1);
        if (this.siteKey != null) {
            return;
        }
        if (this.encryptionIs == null) {
            this.siteKey = this.defaultSiteKey;
            return;
        }
        try {
            IniFile crypto = new IniFile(this.encryptionIs);
            this.siteKey = crypto.getProperty("Encryption", "SiteKey", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.siteKey = this.siteKey == null ? this.defaultSiteKey : this.siteKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFromKeyFile(int lineNo) {
        String s = null;
        BufferedReader reader = null;
        try {
            String fileKeyName = "application.key";
            String fileKeyName1 = ApplicationContext.getInstance().getServletEngineDefaultPath();
            InputStream is = ResourceReader.getFile(fileKeyName);
            reader = new BufferedReader(new InputStreamReader(is));
            for (int i = 0; i < lineNo; ++i) {
                reader.readLine();
            }
            s = reader.readLine();
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    System.err.println("getFromKeyFile: Error closing reader");
                }
            }
        }
        return s;
    }

    public String toString() {
        return "IniFile" + this.hashCode() + " : " + this.fileHandle.getName();
    }

    public void setAutomaticReloading(boolean isAutomaticReloading) {
        this.isAutomaticReloading = isAutomaticReloading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.read();
            }
            catch (IOException e) {
                System.err.println("Error reloading " + this.fileHandle.getName());
            }
            this.lastReloadTime = System.currentTimeMillis();
        }
    }

    public void read() throws IOException {
        String line;
        this.sections = new Hashtable();
        String actSection = "";
        int ncomment = 0;
        Hashtable<String, Value> properties = new Hashtable<String, Value>();
        IniLine il = new IniLine();
        while ((line = this.br.readLine()) != null) {
            il.parse(line);
            if (il.typeLine == 1) {
                actSection = il.section.toUpperCase();
                properties = new Hashtable();
                this.sections.put(actSection, new Section(il.section, properties));
                continue;
            }
            if (il.typeLine == 2) {
                String mappedKey = this.getMappedProperty(actSection, il.property);
                String envValue = EnvVarReader.getEnvironmentVar(actSection, il.property, mappedKey);
                if (envValue != null) {
                    il.value = envValue;
                }
                properties.put(il.property.toUpperCase(), new Value(2, il.property, il.value));
                continue;
            }
            if (il.typeLine != 3) continue;
            properties.put("Comment;" + ++ncomment, new Value(3, il.comment, ""));
            this.sections.put(actSection, properties);
        }
        this.br.close();
    }

    public Vector<String> getPropertyList(String section, String prefix) {
        String tmp;
        Vector<String> out = new Vector<String>();
        int idx = 0;
        while ((tmp = this.getProperty(section, prefix + idx++)) != null) {
            out.addElement(tmp);
        }
        return out;
    }

    public void setPropertyList(String section, String prefix, Vector list) {
        int idx = 0;
        while (this.getProperty(section, prefix + idx) != null) {
            this.removeProperty(section, prefix + idx);
            ++idx;
        }
        for (idx = 0; idx < list.size(); ++idx) {
            this.setProperty(section, prefix + idx, (String)list.elementAt(idx));
        }
        while (!this.getProperty(section, prefix + idx, "").equals("")) {
            this.removeProperty(section, prefix + idx);
            ++idx;
        }
    }

    public void setPropertyEncrypted(String section, String key, String value) {
        String serverKey = this.getServerKey();
        if (key.equals("USER_PASSWORD")) {
            serverKey = Encryption.inverseKey(serverKey);
        }
        this.setProperty(section, key, Encryption.encrypt64(value + Encryption.checksum(value, Encryption.getCheckSumLength()), serverKey));
    }

    public String getPropertyEncrypted(String section, String key) {
        String val = this.getProperty(section, key);
        return this.decryptValue(val, key);
    }

    public String decryptValue(String val, String key) {
        if (val != null) {
            int checkSumLength = Encryption.getCheckSumLength();
            if (val.length() > checkSumLength) {
                String nocheck;
                String checksum;
                String dec;
                String serverKey = this.getServerKey();
                if (key.equals("USER_PASSWORD")) {
                    serverKey = Encryption.inverseKey(serverKey);
                }
                if ((dec = Encryption.decrypt64(val, serverKey)).length() >= checkSumLength && (checksum = CommonUtil.right(dec, checkSumLength)).equals(Encryption.checksum(nocheck = CommonUtil.left(dec, dec.length() - checkSumLength), Encryption.getCheckSumLength()))) {
                    return nocheck;
                }
            }
        }
        return val;
    }

    public String getPropertyEncrypted(String section, String key, String defaultValue) {
        String ret = this.getPropertyEncrypted(section, key);
        return ret == null ? defaultValue : ret;
    }

    public boolean sectionExists(String section) {
        return this.sections.get(section.toUpperCase()) != null;
    }

    public void copySection(IniFile from, String sectionFrom, String sectionTo) {
        Section newSection = from.getSection(sectionFrom);
        newSection.key = sectionTo;
        this.sections.put(sectionTo.toUpperCase(), newSection);
    }

    public Section getSection(String name) {
        return (Section)this.sections.get(name.toUpperCase());
    }

    public int getIntegerProperty(String section, String key) {
        return (int)CommonUtil.val(this.getProperty(section, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String section, String key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isAutomaticReloading && this.lastReloadTime + 5000L < System.currentTimeMillis() && this.fileHandle != null && this.fileHandle.lastModified() > this.lastReloadTime) {
                this.reload();
            }
        }
        return this.getPropertyImpl(section, key);
    }

    public int getIntegerProperty(String section, String key, String defaultValue) {
        return (int)CommonUtil.val(this.getProperty(section, key, defaultValue));
    }

    private String getPropertyImpl(String section, String key) {
        Value value;
        String mapped = this.getMappedProperty(section, key);
        String envValue = EnvVarReader.getEnvironmentVar(section, key, mapped);
        if (envValue != null) {
            return envValue;
        }
        String output = null;
        Section sec = (Section)this.sections.get(section.toUpperCase());
        Hashtable prop = null;
        if (sec != null) {
            prop = sec.values;
        }
        if (prop != null && (value = (Value)prop.get(key.toUpperCase())) != null) {
            output = value.value;
        }
        return output;
    }

    private String getFullSectionKey(String section, String key) {
        if (section != null && !section.isEmpty() && section != "Client") {
            return String.format("%s:%s", section, key);
        }
        return key;
    }

    private String getMappedProperty(String section, String key) {
        String fullKey = this.getFullSectionKey(section, key);
        if (this.isMappedProperty(fullKey)) {
            return IniFile.getConfMapping().get(fullKey);
        }
        return null;
    }

    private boolean isMappedProperty(String key) {
        return IniFile.getConfMapping() != null && IniFile.getConfMapping().containsKey(key);
    }

    static ConcurrentHashMap<String, String> getConfMapping() {
        if (s_confMapping == null) {
            String folderPath = ApplicationContext.getInstance().getServletEngineDefaultPath() + File.separatorChar + "WEB-INF";
            File envMapping = new File(folderPath, CONFMAPPING_FILE);
            if (!envMapping.exists()) {
                envMapping = new File(CONFMAPPING_FILE);
            }
            if (envMapping.isFile()) {
                GXFileInfo mapping = new GXFileInfo(envMapping);
                try {
                    String jsonTxt = mapping.readAllText("");
                    JSONObjectWrapper jObject = new JSONObjectWrapper(jsonTxt);
                    s_confMapping = new ConcurrentHashMap();
                    Iterator keys = jObject.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        String value = jObject.getString(key);
                        s_confMapping.put(key, value);
                    }
                }
                catch (Exception e) {
                    s_confMapping = new ConcurrentHashMap();
                }
            } else {
                s_confMapping = new ConcurrentHashMap();
            }
        }
        return s_confMapping;
    }

    public boolean propertyExists(String section, String key) {
        return this.getPropertyImpl(section, key) != null;
    }

    public String getProperty(String section, String key, String defaultValue) {
        String output = this.getPropertyImpl(section, key);
        return output == null ? defaultValue : output;
    }

    public void setProperty(String section, String key, long value) {
        this.setProperty(section, key, CommonUtil.str(value, 12, 0).trim());
    }

    public void setProperty(String section, String key, double value) {
        this.setProperty(section, key, CommonUtil.str(value, 10, 0).trim());
    }

    public void setProperty(String section, String key, String value) {
        Hashtable<String, Value> sectionHash;
        Section sec = (Section)this.sections.get(section.toUpperCase());
        if (sec == null) {
            sectionHash = new Hashtable<String, Value>();
            sec = new Section(section, sectionHash);
            this.sections.put(section.toUpperCase(), sec);
        } else {
            sectionHash = sec.values;
        }
        sectionHash.put(key.toUpperCase(), new Value(2, key, value));
    }

    public void removeProperty(String section, String key) {
        Section sec = (Section)this.sections.get(section.toUpperCase());
        if (sec != null) {
            sec.values.remove(key.toUpperCase());
        }
    }

    public void saveAs(String fileName) {
        this.saveFile(new File(fileName));
    }

    public void save() {
        this.saveFile(this.fileHandle);
    }

    public void saveFile(File fileHandle) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fileHandle));){
            Enumeration eSec = this.sections.elements();
            while (eSec.hasMoreElements()) {
                Section section = (Section)eSec.nextElement();
                bw.write(91);
                bw.write(section.key, 0, section.key.length());
                bw.write(93);
                bw.newLine();
                Hashtable properties = section.values;
                Enumeration eProp = properties.elements();
                while (eProp.hasMoreElements()) {
                    Value value = (Value)eProp.nextElement();
                    bw.write(value.key, 0, value.key.length());
                    if (value.type != 3) {
                        bw.write(61);
                        bw.write(value.value, 0, value.value.length());
                    }
                    bw.newLine();
                }
            }
            bw.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
        }
    }

    static {
        CONFMAPPING_FILE = "confmapping.json";
    }

    class IniLine {
        int typeLine;
        String section;
        String property;
        String value;
        String comment;

        IniLine() {
        }

        public void parse(String line) {
            this.section = "";
            this.property = "";
            this.value = "";
            this.typeLine = 2;
            int left = line.indexOf(61);
            if (left >= 0) {
                this.property = line.substring(0, line.indexOf(61)).trim();
                this.value = line.substring(line.indexOf(61) + 1, line.length()).trim();
                return;
            }
            left = line.indexOf(91);
            if (left == 0) {
                this.section = line.substring(left + 1, line.indexOf(93)).trim();
                this.typeLine = 1;
                return;
            }
            if (line.trim().indexOf(59) == 0) {
                this.comment = line.trim();
                this.typeLine = 3;
                return;
            }
            if (line.trim().equals("")) {
                this.typeLine = 4;
            } else {
                System.err.println("Unrecognized line " + line);
            }
        }
    }

    class Section {
        String key;
        Hashtable values;

        public Section(String key, Hashtable values) {
            this.key = key;
            this.values = values;
        }
    }

    class Value {
        int type;
        String key;
        String value;

        public Value(int type, String key, String value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }
    }
}

