/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.ISubmitteable;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.util.ReorgBlock;
import com.genexus.util.ReorgSubmitThread;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ReorgSubmitThreadPool {
    public static final String SUBMIT_THREAD = "SubmitThread-";
    private static ReorgSubmitThread[] threadPool = null;
    private static Vector<Object[]> submitQueue = new Vector();
    private static Vector<Object[]> submitPrecedenceQueue = new Vector();
    private static int remainingSubmits = 0;
    private static Object lockObject = new Object();
    private static boolean onlyOneThread = false;
    private static boolean hasAnError = false;
    private static int errorCount = 0;
    static Hashtable<String, ReorgBlock> blocks = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startProcess() {
        if (threadPool == null) {
            threadPool = onlyOneThread ? new ReorgSubmitThread[1] : new ReorgSubmitThread[SpecificImplementation.Application.getDefaultPreferences().getSUBMIT_POOL_SIZE()];
        }
        for (int i = 0; i < threadPool.length; ++i) {
            if (submitQueue.size() <= 0) continue;
            Object[] nextSubmit = submitQueue.firstElement();
            submitQueue.removeElement(nextSubmit);
            ReorgSubmitThreadPool.threadPool[i] = new ReorgSubmitThread(i);
            threadPool[i].start();
            while (!threadPool[i].isInitialized()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ReorgSubmitThread reorgSubmitThread = threadPool[i];
            synchronized (reorgSubmitThread) {
                threadPool[i].setProc((String)nextSubmit[2], (ISubmitteable)nextSubmit[0], (Integer)nextSubmit[1], SpecificImplementation.Application.getModelContext());
                threadPool[i].notify();
                continue;
            }
        }
    }

    public static void setOnlyOneThread() {
        onlyOneThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void incRemainingSubmits() {
        Object object = lockObject;
        synchronized (object) {
            ++remainingSubmits;
        }
    }

    protected static synchronized void decRemainingSubmits() {
        if (--remainingSubmits == 0 || errorCount == SpecificImplementation.Application.getDefaultPreferences().getSUBMIT_POOL_SIZE() || errorCount > 0 && onlyOneThread) {
            ReorgSubmitThreadPool.class.notify();
        }
    }

    public static synchronized void waitForEnd() {
        if (remainingSubmits > 0) {
            System.err.println("Waiting for " + remainingSubmits + " submitted procs to end...");
        }
        while (!(onlyOneThread && errorCount > 0 || remainingSubmits <= 0 || errorCount == SpecificImplementation.Application.getDefaultPreferences().getSUBMIT_POOL_SIZE())) {
            try {
                ReorgSubmitThreadPool.class.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setAnError() {
        hasAnError = true;
        ++errorCount;
    }

    public static boolean hasAnyError() {
        return hasAnError;
    }

    protected static synchronized Object[] getNextSubmit() {
        if (submitQueue.size() <= 0) {
            Enumeration<Object[]> enumPrecedence = submitPrecedenceQueue.elements();
            while (enumPrecedence.hasMoreElements()) {
                String blockName;
                Object[] nextPrecedenceSubmit = enumPrecedence.nextElement();
                int id = (Integer)nextPrecedenceSubmit[1];
                if (!ReorgSubmitThreadPool.allPrecedencesEnded(id, blockName = (String)nextPrecedenceSubmit[2])) continue;
                ISubmitteable proc = (ISubmitteable)nextPrecedenceSubmit[0];
                submitPrecedenceQueue.removeElement(nextPrecedenceSubmit);
                ReorgSubmitThreadPool.incRemainingSubmits();
                submitQueue.addElement(new Object[]{proc, new Integer(id), blockName});
            }
        }
        if (submitQueue.size() > 0) {
            Object[] nextSubmit = submitQueue.firstElement();
            submitQueue.removeElement(nextSubmit);
            return nextSubmit;
        }
        return null;
    }

    public static void addBlock(String blockName) {
        blocks.put(blockName, new ReorgBlock());
    }

    public static void addPrecedence(String blockName, String precedence) {
        blocks.get(blockName).addPrecedence(precedence);
    }

    public static void submitReorg(String blockName, String message, ISubmitteable proc, int id) {
        Vector<String> precedence = blocks.get(blockName).getPrecedences();
        blocks.get(blockName).setMessage(message);
        if (precedence == null) {
            ReorgSubmitThreadPool.incRemainingSubmits();
            submitQueue.addElement(new Object[]{proc, new Integer(id), blockName});
        } else {
            submitPrecedenceQueue.addElement(new Object[]{proc, new Integer(id), blockName});
        }
    }

    private static boolean allPrecedencesEnded(int id, String blockName) {
        Vector<String> precedence = blocks.get(blockName).getPrecedences();
        if (precedence == null) {
            return true;
        }
        Enumeration<String> enum1 = precedence.elements();
        while (enum1.hasMoreElements()) {
            String precede = enum1.nextElement();
            if (blocks.get(precede).getEnded()) continue;
            String message = blocks.get(blockName).getMessage() + " WAITING FOR " + blocks.get(precede).getMessage();
            SpecificImplementation.Application.replaceMsg(id, message);
            return false;
        }
        return true;
    }
}

