/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.Log;
import com.genexus.util.ThemeData;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;

public class ThemeHelper {
    private static Map<String, ThemeData> m_themes = Collections.synchronizedMap(new HashMap());

    private static ThemeData createDefaultThemeData(String themeName) {
        ThemeData themeData = new ThemeData();
        themeData.name = themeName;
        themeData.baseLibraryCssReferences = new String[0];
        return themeData;
    }

    private static ThemeData getThemeData(String themeName) {
        if (!m_themes.containsKey(themeName)) {
            ThemeData themeData;
            File baseDirectory = new File(ApplicationContext.getInstance().getServletEngineDefaultPath());
            File themesDirectory = new File(baseDirectory, "themes");
            File themesJsonFile = new File(themesDirectory, themeName + ".json");
            try {
                String json = ApplicationContext.getInstance().isSpringBootApp() ? new ClassPathResource("themes/" + themeName + ".json").getContentAsString(StandardCharsets.UTF_8) : SpecificImplementation.GXutil.readFileToString(themesJsonFile, CommonUtil.normalizeEncodingName("UTF-8"));
                themeData = ThemeData.fromJson(json);
            }
            catch (Exception ex) {
                Log.warning("Unable to load theme metadata (" + themeName + "). Using an empty default one.", "", ex);
                themeData = ThemeHelper.createDefaultThemeData(themeName);
            }
            m_themes.put(themeName, themeData);
        }
        return m_themes.get(themeName);
    }

    public static String[] getThemeCssReferencedFiles(String themeName) {
        ThemeData themeData = ThemeHelper.getThemeData(themeName);
        return themeData.baseLibraryCssReferences;
    }
}

