/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.xml;

import com.genexus.CommonUtil;
import com.genexus.IXMLWriter;
import com.genexus.com.IHttpResponse;
import com.genexus.internet.HttpClient;
import com.genexus.util.NameValuePair;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class XMLWriter
implements IXMLWriter {
    private static boolean useTagToCloseElement;
    private static final byte GXSUCCESS = 0;
    private static final byte GXFAIL = 1;
    private static final byte GXOUTPUT_ERROR = 2;
    private String sCurrValue;
    private String sCurrPrefix;
    private Stack<NameValuePair> stack = new Stack();
    private Vector<NameValuePair> attributes = new Vector();
    private Hashtable<String, String> namespaces = new Hashtable();
    private StringWriter sWriter = null;
    private int inValue = 0;
    private boolean bOpenValue;
    private boolean bOpenElementHeader;
    private String indentChar = "\t";
    private String errDescription = "";
    private short indentation = 1;
    private int errCode = 0;
    private boolean openedWriter = true;
    private boolean simpleElement = false;
    private boolean textFlag = false;
    private boolean printingEndElement = false;
    private String encoding = "";
    private Writer out = null;
    private OutputStream stream;
    private int entities = 0;
    private StringBuffer openRequestEncoding = null;

    public byte getUseentities() {
        return (byte)this.entities;
    }

    public void setUseentities(int entities) {
        this.entities = entities;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = CommonUtil.normalizeEncodingName(enc);
    }

    private void checkWriter() {
        if (this.out == null && this.stream != null) {
            try {
                this.out = new OutputStreamWriter(this.stream, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                this.out = new OutputStreamWriter(this.stream);
            }
        }
    }

    @Override
    public byte xmlEnd() {
        while (!this.stack.empty()) {
            this.writeEndElement();
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public byte xmlStartWeb(String sFileName) {
        this.sWriter = null;
        return 0;
    }

    @Override
    public byte xmlStart(String sFileName) {
        this.sWriter = null;
        this.stack.removeAllElements();
        this.xmlEnd();
        this.textFlag = false;
        try {
            this.stream = sFileName.trim().length() > 0 ? new BufferedOutputStream(new FileOutputStream(sFileName)) : new FileOutputStream(FileDescriptor.out);
        }
        catch (IOException e) {
            return 1;
        }
        return 0;
    }

    public byte openToString() {
        this.sWriter = new StringWriter();
        this.stack.removeAllElements();
        this.xmlEnd();
        this.textFlag = false;
        this.out = new PrintWriter(this.sWriter);
        return 0;
    }

    public String getResultingString() {
        if (this.sWriter == null) {
            return "";
        }
        return this.sWriter.toString();
    }

    public void setOutputStream(OutputStream oStream) {
        this.xmlEnd();
        this.stream = oStream;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    @Override
    public byte xmlBeginElement(String sLevelName) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        return this.OpenElementHeader(sLevelName, "") ? (byte)0 : 1;
    }

    @Override
    public byte xmlEndElement() {
        this.checkWriter();
        this.printingEndElement = true;
        this.CloseElementHeaderAndValue();
        if (this.stack.empty()) {
            this.errCode = 1;
            this.errDescription = "Stack underflow";
            this.printingEndElement = false;
            return 1;
        }
        NameValuePair node = this.stack.pop();
        if (this.printingEndElement) {
            this.printIndentation();
            String prefix = this.namespaces.get(node.value);
            if (prefix == null) {
                prefix = "";
            }
            try {
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    this.out.write("</" + prefix + ":" + node.name + ">\n");
                } else {
                    this.out.write("</" + node.name + ">\n");
                }
            }
            catch (NullPointerException e) {
                this.errCode = 2;
            }
            catch (IOException e) {
                this.errCode = 2;
            }
            this.printingEndElement = false;
        }
        this.inValue = 0;
        return (byte)this.errCode;
    }

    @Override
    public byte xmlText(String sTag) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            this.out.write(CommonUtil.quoteString(sTag, this.entities != 0, false));
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return (byte)this.errCode;
    }

    @Override
    public byte xmlRaw(String sTag) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            this.out.write(sTag);
            this.textFlag = true;
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return (byte)this.errCode;
    }

    @Override
    public byte xmlValue(String sTag, Date sValue) {
        this.xmlBeginElement(sTag);
        return this.OpenValue(sValue.toString()) ? (byte)0 : 1;
    }

    @Override
    public byte xmlValue(String sTag, String sValue) {
        this.xmlBeginElement(sTag);
        return this.OpenValue(sValue) ? (byte)0 : 1;
    }

    @Override
    public byte xmlValue(String sTag, long nValue) {
        this.xmlBeginElement(sTag);
        return this.OpenValue(Long.toString(nValue)) ? (byte)0 : 1;
    }

    @Override
    public byte xmlValue(String sTag, double dValue) {
        this.xmlBeginElement(sTag);
        return this.OpenValue(Double.toString(dValue)) ? (byte)0 : 1;
    }

    @Override
    public byte xmlValue(String sTag, BigDecimal dValue) {
        return this.xmlValue(sTag, dValue.doubleValue());
    }

    @Override
    public byte xmlAtt(String sName, String sValue) {
        this.checkWriter();
        try {
            this.out.write(" " + sName + "=\"" + sValue + "\"");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return (byte)this.errCode;
    }

    @Override
    public byte xmlAtt(String sName, long nValue) {
        this.checkWriter();
        try {
            this.out.write(" " + sName + "=\"" + nValue + "\"");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return (byte)this.errCode;
    }

    @Override
    public byte xmlAtt(String sName, double nValue) {
        this.checkWriter();
        try {
            this.out.write(" " + sName + "=\"" + nValue + "\"");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return (byte)this.errCode;
    }

    @Override
    public byte xmlAtt(String sName, BigDecimal dValue) {
        return this.xmlAtt(sName, dValue.doubleValue());
    }

    private boolean OpenValue(String sValue) {
        this.bOpenValue = true;
        this.sCurrValue = sValue;
        return true;
    }

    private boolean OpenElementHeader(String sLevelName, String sLevelURI) {
        this.CloseElementHeaderAndValue();
        this.stack.push(new NameValuePair(sLevelName, sLevelURI));
        this.bOpenElementHeader = true;
        return true;
    }

    private int getCurrentLevel() {
        return this.stack.size();
    }

    private void printIndentation() {
        this.printIndentation(this.getCurrentLevel());
    }

    private void printIndentation(int level) {
        try {
            if (this.inValue == 2) {
                return;
            }
            if (this.inValue == 1) {
                this.inValue = 2;
            }
            if (this.textFlag) {
                this.out.write("\n");
            }
            this.textFlag = false;
            if (this.indentation != 0 && level > 0) {
                this.out.write(CommonUtil.replicate(this.indentChar, level * this.indentation));
            }
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    private boolean CloseElementHeaderAndValue() {
        if (!this.bOpenElementHeader) {
            return false;
        }
        NameValuePair node = this.stack.peek();
        String prefix = this.namespaces.get(node.value);
        if (node.value.length() != 0 && (prefix == null || this.sCurrPrefix.length() > 0 && !prefix.equals(this.sCurrPrefix))) {
            prefix = this.sCurrPrefix;
            this.writeAttribute("xmlns" + (prefix.length() > 0 ? ":" + prefix : ""), node.value);
        }
        if (prefix == null) {
            prefix = "";
        }
        this.printIndentation(this.getCurrentLevel() - 1);
        try {
            this.out.write("<");
            if (prefix.length() > 0) {
                this.out.write(prefix);
                this.out.write(":");
            }
            this.out.write(node.name);
            Enumeration<NameValuePair> en = this.attributes.elements();
            while (en.hasMoreElements()) {
                NameValuePair vp = en.nextElement();
                this.out.write(" " + vp.name + "=\"" + CommonUtil.quoteString(vp.value, this.entities != 0, true) + "\"");
            }
            this.attributes.removeAllElements();
            if (this.bOpenValue) {
                this.bOpenValue = false;
                if (this.IsBlank(this.sCurrValue)) {
                    this.out.write("/>\n");
                } else {
                    this.out.write(">");
                    this.out.write(CommonUtil.quoteString(this.sCurrValue, this.entities != 0, false));
                    this.out.write("</");
                    if (prefix.length() > 0) {
                        this.out.write(prefix);
                        this.out.write(":");
                    }
                    this.out.write(node.name);
                    this.out.write(">\n");
                }
                this.stack.pop();
            } else if (this.printingEndElement && this.IsBlank(this.sCurrValue) && !useTagToCloseElement) {
                this.out.write("/>\n");
                this.printingEndElement = false;
            } else if (this.inValue == 0) {
                this.out.write(">\n");
            } else {
                this.out.write(">");
            }
            this.bOpenElementHeader = false;
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
        return true;
    }

    private boolean IsBlank(String s) {
        return s == null || s.length() == 0;
    }

    public byte openRequest(HttpClient resp) {
        this.openRequestEncoding = new StringBuffer();
        StringWriter writer = new StringWriter();
        this.out = new PrintWriter(writer);
        resp.addStringWriter(writer, this.openRequestEncoding);
        return 0;
    }

    public byte openResponse(IHttpResponse resp) {
        this.sWriter = null;
        this.stack.removeAllElements();
        this.xmlEnd();
        this.textFlag = false;
        try {
            this.stream = resp.getOutputStream();
        }
        catch (IOException e) {
            return 1;
        }
        return 0;
    }

    public byte openResponse(OutputStream s) {
        this.sWriter = null;
        this.stack.removeAllElements();
        this.xmlEnd();
        this.textFlag = false;
        this.setOutputStream(s);
        return 0;
    }

    public byte openResponse(PrintWriter writer) {
        this.out = writer;
        return 0;
    }

    public byte openResponse(String sFileName) {
        return 0;
    }

    public void setIndentChar(String indentChar) {
        this.indentChar = indentChar;
    }

    public String getIndentChar() {
        return this.indentChar;
    }

    public void setIndentation(int indentation) {
        this.indentation = (short)indentation;
    }

    public short getIndentation() {
        return this.indentation;
    }

    public short getErrCode() {
        return (short)this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    public byte openURL(String sFileName) {
        return this.xmlStart(sFileName);
    }

    public byte writeStartElement(String sLevelName) {
        return this.xmlBeginElement(sLevelName);
    }

    public void writeNSStartElement(String sLevelName) {
        this.writeNSStartElement(sLevelName, "", "");
    }

    public void writeNSStartElement(String sLevelName, String sPrefix, String sURI) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        this.OpenElementHeader(sLevelName, sURI);
        this.sCurrPrefix = sPrefix;
    }

    public byte writeEndElement() {
        return this.xmlEndElement();
    }

    public void writeComment(String comment) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        this.printIndentation();
        try {
            this.out.write("<!--" + comment + "-->\n");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeProcessingInstruction(String pi) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        this.printIndentation();
        try {
            this.out.write("<?" + pi + "?>\n");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeProcessingInstruction(String pi, String value) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        this.printIndentation();
        try {
            this.out.write("<?" + pi + " " + value + "?>\n");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeDocType(String name) {
        this.writeDocType(name, "");
    }

    public void writeDocType(String name, String subset) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            if (subset.trim().isEmpty()) {
                this.out.write("<!DOCTYPE " + name.trim() + ">\n");
            } else {
                this.out.write("<!DOCTYPE " + name.trim() + " [" + subset + "]>\n");
            }
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeDocTypeSystem(String name, String uri) {
        this.writeDocTypeSystem(name, uri, "");
    }

    public void writeDocTypeSystem(String name, String uri, String subset) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            if (subset.trim().isEmpty()) {
                this.out.write("<!DOCTYPE " + name.trim() + " SYSTEM  \"" + uri + "\">\n");
            } else {
                this.out.write("<!DOCTYPE " + name.trim() + " SYSTEM  \"" + uri + "\" [" + subset + "]>\n");
            }
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeDocTypePublic(String name, String pubid, String uri) {
        this.writeDocTypePublic(name, pubid, uri, "");
    }

    public void writeDocTypePublic(String name, String pubid, String uri, String subset) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            if (subset.trim().isEmpty()) {
                this.out.write("<!DOCTYPE " + name.trim() + " PUBLIC \"" + pubid + "\" \"" + uri + "\">\n");
            } else {
                this.out.write("<!DOCTYPE " + name.trim() + " PUBLIC \"" + pubid + "\" \"" + uri + "\" [" + subset + "]>\n");
            }
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeEntityReference(String value) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        try {
            this.out.write("&" + value.trim() + ";");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public void writeCData(String data) {
        this.checkWriter();
        this.CloseElementHeaderAndValue();
        this.printIndentation();
        try {
            this.out.write("<![CDATA[" + data + "]]>\n");
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public byte writeElement(String sLevelName) {
        return this.writeElement(sLevelName, "");
    }

    public byte writeElement(String sName, String sValue) {
        this.CloseElementHeaderAndValue();
        this.simpleElement = true;
        this.xmlValue(sName, sValue);
        return 0;
    }

    public byte writeElement(String sName, long sValue) {
        return this.writeElement(sName, Long.toString(sValue));
    }

    public byte writeElement(String sName, double sValue) {
        return this.writeElement(sName, Double.toString(sValue));
    }

    public byte writeElement(String sName, BigDecimal dValue) {
        return this.writeElement(sName, dValue.doubleValue());
    }

    public void writeNSElement(String sLevelName) {
        this.writeNSElement(sLevelName, "", "");
    }

    public void writeNSElement(String sLevelName, String sURI) {
        this.writeNSElement(sLevelName, sURI, "");
    }

    public void writeNSElement(String sLevelName, String sURI, String sValue) {
        this.writeNSStartElement(sLevelName, "", sURI);
        this.OpenValue(sValue);
    }

    public byte writeAttribute(String name, String value) {
        if (this.bOpenElementHeader || this.bOpenValue) {
            this.attributes.addElement(new NameValuePair(name, value));
            String prefix = this.getNamespace(name);
            if (prefix != null) {
                this.namespaces.put(value.trim(), prefix);
            }
        } else {
            this.errCode = 1;
        }
        return (byte)this.errCode;
    }

    public String getNamespace(String nm) {
        if ((nm = nm.trim()).startsWith("xmlns:")) {
            return nm.substring(6);
        }
        return null;
    }

    public byte writeAttribute(String sName, long sValue) {
        return this.writeAttribute(sName, Long.toString(sValue));
    }

    public byte writeAttribute(String sName, double sValue) {
        return this.writeAttribute(sName, Double.toString(sValue));
    }

    public byte writeAttribute(String sName, BigDecimal dValue) {
        return this.writeAttribute(sName, dValue.doubleValue());
    }

    public byte writeText(String sTag) {
        this.inValue = 1;
        this.CloseElementHeaderAndValue();
        return this.xmlText(sTag);
    }

    public byte writeRawText(String sTag) {
        this.CloseElementHeaderAndValue();
        return this.xmlRaw(sTag);
    }

    public void writeStartDocument() {
        this.writeStartDocument(this.encoding, 0);
    }

    public void writeStartDocument(String encod) {
        this.writeStartDocument(encod, 0);
    }

    public void writeStartDocument(String encod, int standalone) {
        this.setEncoding(encod);
        if (this.openRequestEncoding != null) {
            this.openRequestEncoding.setLength(0);
            this.openRequestEncoding.append(this.encoding);
        }
        this.checkWriter();
        try {
            String cannonicalName;
            try {
                CommonUtil.normalizeSupportedEncodingName(encod);
                cannonicalName = CommonUtil.ianaEncodingName(encod.trim());
            }
            catch (Throwable e2) {
                cannonicalName = CommonUtil.normalizeEncodingName(encod);
            }
            String temp = "<?xml version=\"1.0\" encoding=\"" + cannonicalName + "\"" + (standalone != 0 ? " standalone=\"yes\"" : "") + "?>\n";
            if (this.stream != null) {
                for (int i = 0; i < temp.length(); ++i) {
                    this.stream.write((byte)temp.charAt(i));
                }
            } else {
                for (int i = 0; i < temp.length(); ++i) {
                    this.out.write((byte)temp.charAt(i));
                }
            }
        }
        catch (NullPointerException e) {
            this.errCode = 2;
        }
        catch (IOException e) {
            this.errCode = 2;
        }
    }

    public byte close() {
        this.xmlEnd();
        return 0;
    }

    public static void setUseTagToCloseElement(boolean useTagToCloseElementParm) {
        useTagToCloseElement = useTagToCloseElementParm;
    }
}

