package com.geotab.api;

import static com.geotab.api.Api.method;

import com.geotab.api.Api.MethodDescriptor;
import com.geotab.http.request.param.AuthenticateParameters;
import com.geotab.http.request.param.AuthenticatedParameters;
import com.geotab.http.request.param.GetAddressesParameters;
import com.geotab.http.request.param.GetCoordinatesParameters;
import com.geotab.http.request.param.GetDaylightSavingRulesParameters;
import com.geotab.http.request.param.GetDirectionsParameters;
import com.geotab.http.request.param.GetRoadMaxSpeedsParameters;
import com.geotab.http.request.param.OptimizeWaypointsParameters;
import com.geotab.model.Dictionary;
import com.geotab.model.ReverseGeocodeAddress;
import com.geotab.model.TimeZoneInfo;
import com.geotab.model.TimeZoneInfoWithRules;
import com.geotab.model.VersionInformation;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.geographical.Directions;
import com.geotab.model.geographical.Waypoint;
import com.geotab.model.login.LoginResult;
import java.time.Instant;
import java.util.List;

/**
 * List of WebMethods type-safe descriptors.
 *
 * <p><b>WARNING:</b> Experimental API.
 */
public interface WebMethods {
  //@formatter:off
  MethodDescriptor<GetRoadMaxSpeedsParameters, Dictionary<Instant, Float>> GetRoadMaxSpeeds = method("GetRoadMaxSpeeds", Dictionary.class, Instant.class, Float.class);
  MethodDescriptor<AuthenticatedParameters, String> GetVersion = method("GetVersion", String.class);
  MethodDescriptor<AuthenticatedParameters, VersionInformation> GetVersionInformation = method("GetVersionInformation", VersionInformation.class);
  MethodDescriptor<AuthenticatedParameters, List<TimeZoneInfo>> GetTimeZones = method("GetTimeZones", List.class, TimeZoneInfo.class);
  MethodDescriptor<AuthenticateParameters, LoginResult> Authenticate = method("Authenticate", LoginResult.class);
  MethodDescriptor<GetAddressesParameters, List<ReverseGeocodeAddress>> GetAddresses = method("GetAddresses", List.class, ReverseGeocodeAddress.class);
  MethodDescriptor<GetCoordinatesParameters, List<Coordinate>> GetCoordinates = method("GetCoordinates", List.class, Coordinate.class);
  MethodDescriptor<OptimizeWaypointsParameters, List<Waypoint>> OptimizeWaypoints = method("OptimizeWaypoints", List.class, Waypoint.class);
  MethodDescriptor<GetDirectionsParameters, Directions> GetDirections = method("GetDirections", Directions.class);
  MethodDescriptor<GetDaylightSavingRulesParameters, TimeZoneInfoWithRules> GetDaylightSavingRules = method("GetDaylightSavingRules", TimeZoneInfoWithRules.class);
  //@formatter:on
}
