/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

import com.geotab.util.Util;
import java.util.Optional;

/**
 * This exception is thrown on a logon with an incorrect user/password combination or when the user's credentials become
 * invalid.
 */
public class InvalidUserException extends JsonRpcErrorDataException {

  public InvalidUserException() {
    this(null, null, null);
  }

  public InvalidUserException(String database, Exception exception, InvalidUserType invalidUserType) {
    super(Optional.ofNullable(invalidUserType).orElse(InvalidUserType.DEFAULT).getDescription()
        + (Util.isEmpty(database) ? "" : " @ '" + database + "'"), exception);
  }
}
