/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.exception;

import com.geotab.http.invoker.ServerInvoker;
import com.geotab.model.error.JsonRpcErrorData;
import java.util.Map;
import lombok.Getter;

/**
 * The exception thrown for JSON errors in {@link ServerInvoker}.
 */
public class ServerInvokerJsonException extends JsonRpcErrorDataException {

  private String stackTrace;
  @Getter
  private Map<String, String> innerError;

  public ServerInvokerJsonException(String message, String stackTrace, Map<String, String> innerError,
      JsonRpcErrorData errorData) {
    super(message);
    this.stackTrace = stackTrace;
    this.innerError = innerError;
    this.errorData = errorData;
  }

  /**
   * Gets a string representation of the frames on the call stack at the time the current exception was thrown.
   *
   * @return A string that describes the immediate frames of the call stack.
   */
  public String getServerStackTrace() {
    return stackTrace != null ? stackTrace : "";
  }
}
