/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.http.request.param.AuthenticatedParameters;
import com.geotab.model.login.Credentials;
import java.util.Optional;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "authRequestBuilder")
public class AuthenticatedRequest<T extends AuthenticatedParameters> extends BaseRequest<T> {

  @JsonIgnore
  public Optional<Credentials> getCredentials() {
    return Optional.ofNullable(params).map(AuthenticatedParameters::getCredentials);
  }

  @JsonIgnore
  public void setCredentials(Credentials credentials) {
    if (params != null) params.setCredentials(credentials);
  }
}

