/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.http.request.param;

import com.geotab.model.entity.Entity;
import com.geotab.model.search.Search;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Used for Add, Set, Remove request methods, where the targeted entity needs to be provided.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "entityParamsBuilder")
public class EntityParameters<T extends Search> extends AuthenticatedParameters {

  private Entity entity;
}
