/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.geotab.model.serialization.IdDeserializer;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Represents an object containing just the id.
 *
 * <p>Can be used in a request search to pass an object with id only, or as a class attribute type
 * in which case an incoming "id" property will get serialized to this class.
 *
 * <p>If serialization of this class is needed as string "id" only,
 * then annotate the property with {@link com.geotab.model.serialization.IdAsStringSerializer}
 */
@Data
@NoArgsConstructor
@JsonDeserialize(using = IdDeserializer.class)
public class Id implements Comparable<Id> {

  private String id;

  public Id(String id) {
    this.id = id;
  }

  @Override
  public int compareTo(Id other) {
    if (this.getId() == null && other.getId() == null) {
      return 0;
    } else if (this.getId() == null) {
      return -1;
    } else if (other.getId() == null) {
      return 1;
    } else {
      return this.getId().compareTo(other.getId());
    }
  }
}
