/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TimeZoneInfoAdjustmentRule {
  private LocalDateTime dateEnd;
  private LocalDateTime dateStart;
  private Duration daylightDelta;
  private TransitionTime daylightTransitionEnd;
  private TransitionTime daylightTransitionStart;

  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder
  public static class TransitionTime {
    private int day;
    private DayOfWeek dayOfWeek;
    private int month;
    private LocalDateTime timeOfDay;
    private int week;
    private boolean isFixedDateRule;
  }
}
