/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An {@link Entity} that has a name field.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public abstract class NameEntity extends Entity {

  /**
   * The name of this entity that uniquely identifies it and is used when displaying this entity. Maximum length [50].
   */
  private String name;
}
