/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import static com.geotab.model.entity.controller.BrpFaultController.BRP_FAULT_CONTROLLER_ID;
import static com.geotab.model.entity.controller.GmcccFaultController.GMCC_FAULT_CONTROLLER_ID;
import static com.geotab.model.entity.controller.GoFaultController.GO_FAULT_CONTROLLER_ID;
import static com.geotab.model.entity.controller.LegacyFaultController.LEGACY_FAULT_CONTROLLER_ID;
import static com.geotab.model.entity.controller.NoController.NO_CONTROLLER_ID;
import static com.geotab.model.entity.controller.ProprietaryFaultController.PROPRIETARY_FAULT_CONTROLLER_ID;

import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.source.Source;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The controller that the diagnostic belongs to. Controllers could be ABS controller, suspension controller etc.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Controller extends NameEntityWithVersion {

  /**
   * Controller diagnostic code (if applicable).
   */
  protected Short code;

  /**
   * The message identification code for the controller of the diagnostic (if applicable).
   */
  protected Short codeId;

  /**
   * The standard (format) of the {@link Source}.
   */
  protected Source source;

  public static Controller fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    switch (id) {
      case BRP_FAULT_CONTROLLER_ID:
        return BrpFaultController.getInstance();
      case GMCC_FAULT_CONTROLLER_ID:
        return GmcccFaultController.getInstance();
      case GO_FAULT_CONTROLLER_ID:
        return GoFaultController.getInstance();
      case LEGACY_FAULT_CONTROLLER_ID:
        return LegacyFaultController.getInstance();
      case PROPRIETARY_FAULT_CONTROLLER_ID:
        return ProprietaryFaultController.getInstance();
      case NO_CONTROLLER_ID:
        return NoController.getInstance();
      default:
        return null;
    }
  }
}
