/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.entity.source.SourceGmccc;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * Controller reserved for faults generated with manufacturer specific codes.
 */
@Data
public final class GmcccFaultController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final GmcccFaultController INSTANCE = new GmcccFaultController();
  }

  public static final String GMCC_FAULT_CONTROLLER_ID = "ControllerGmcccFaultId";

  private GmcccFaultController() {
    setId(new Id(GMCC_FAULT_CONTROLLER_ID));
    setName("GMCCC");
    setVersion(-1L);
    setCode((short) 0);
    setCodeId((short) -1);
    setSource(SourceGmccc.getInstance());
  }

  public static GmcccFaultController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
