/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.entity.source.SourceGo;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * Controller reserved for faults generated by the Geotab GO Device.
 */
@Data
public final class GoFaultController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final GoFaultController INSTANCE = new GoFaultController();
  }

  public static final String GO_FAULT_CONTROLLER_ID = "ControllerGoDeviceId";

  private GoFaultController() {
    setId(new Id(GO_FAULT_CONTROLLER_ID));
    setName("Telematics device");
    setVersion(0L);
    setCode((short) 0);
    setCodeId((short) 0);
    setSource(SourceGo.getInstance());
  }

  public static GoFaultController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
