/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

@Data
public final class NoController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoController INSTANCE = new NoController();
  }

  public static final String NO_CONTROLLER_ID = "ControllerNoneId";

  private NoController() {
    setId(new Id(NO_CONTROLLER_ID));
    setName("***Unassigned Controller");
    setVersion(0L);
  }

  public static NoController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
