/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.controller;

import com.geotab.model.Id;
import com.geotab.model.entity.source.SourceProprietary;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * Controller reserved for faults generated with manufacturer specific codes.
 */
@Data
public final class ProprietaryFaultController extends Controller implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final ProprietaryFaultController INSTANCE = new ProprietaryFaultController();
  }

  public static final String PROPRIETARY_FAULT_CONTROLLER_ID = "ControllerProprietaryFaultId";

  private ProprietaryFaultController() {
    setId(new Id(PROPRIETARY_FAULT_CONTROLLER_ID));
    setName("Manufacturer Specific");
    setVersion(-1L);
    setCode((short) 0);
    setCodeId((short) -1);
    setSource(SourceProprietary.getInstance());
  }

  public static ProprietaryFaultController getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
