/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.customdata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Generic Custom Data from a GO unit that was sent through from a third-party device that is attached to the serial
 * port.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class CustomData extends Entity {

  /**
   * The custom data in binary format. Default [empty].
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] data;

  /**
   * The date and time the log was created.
   */
  private LocalDateTime dateTime;

  /**
   * The {@link Device} for which the data was recorded.
   */
  private Device device;
}
