/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.customproperty;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.group.Group;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The property set that groups {@link Property} together based on a grouping structure.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class PropertySet extends EntityWithVersion {

  /**
   * The Name of the PropertySet.
   */
  private String name;

  /**
   * The Properties of the PropertySet.
   */
  private List<Property> properties;

  /**
   * The {@link Group}s of the PropertySet.
   */
  @JsonSerialize(converter = EntityCollectionAsIdCollectionSerializer.class)
  private List<Group> groups;

  /**
   * The External Reference of the PropertySet.
   */
  private String externalReference;
}
