/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.customproperty;

import com.geotab.model.entity.EntityWithVersion;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The custom {@link Property} of an entity that is customizable.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class PropertyValue extends EntityWithVersion {

  /**
   * The value.
   */
  private String value;

  /**
   * The property.
   */
  private Property property;
}
