/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.customproperty;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum SupportedPropertyType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * Integer custom property.
   */
  INTEGER("Integer", 1),

  /**
   * String custom property.
   */
  STRING("String", 2),

  /**
   * Boolean custom property.
   */
  BOOLEAN("Boolean", 3);

  private final String name;
  private final int code;

  SupportedPropertyType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
