package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A custom third-party device that is used in MyGeotab. This is used for extensibility and is based on the {@link
 * Device} object.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "customDeviceBuilder")
public class CustomDevice extends Device {

  {
    setDeviceType(DeviceType.CUSTOM_DEVICE);
  }
}
