package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DevicePlan implements HasName {

  /**
   * Unknown Plan.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", 0),

  /**
   * The Pro Plan.
   */
  PRO("Pro", 1),

  /**
   * The Passive Plan.
   */
  PASSIVE("Passive", 2),

  /**
   * The Base Plan.
   */
  BASE("Base", 3),

  /**
   * The vin-odometer plan.
   */
  VIN_ODOMETER("VinOdometer", 4),

  /**
   * The HOS plan.
   */
  HOS("HOS", 5),

  /**
   * The base + engine plan.
   */
  BASE_ENGINE("BaseEngine", 6),

  /**
   * The Pro Plus Plan.
   */
  PRO_PLUS("ProPlus", 10),

  /**
   * The pro no gps plan.
   */
  PRO_NO_GPS("ProNoGps", 11),

  /**
   * The Enterprise Standard Plan.
   */
  ENTERPRISE_STANDARD("EnterpriseStandard", 12),

  /**
   * The rental mode 1 plan.
   */
  RENTAL_MODE_1("RentalMode1", 13),

  /**
   * The api safety plan.
   */
  API_SAFETY("ApiSafety", 14),

  /**
   * The api maintenance plan.
   */
  API_MAINTENANCE("ApiMaintenance", 15),

  /**
   * The api base plan.
   */
  API_BASE("ApiBase", 16),

  /**
   * The api pro plan.
   */
  API_PRO("ApiPro", 17),

  /**
   * The safety + ODO plan.
   */
  SAFETY_ODO("SafetyOdo", 18),

  /**
   * The maintenance plan.
   */
  MAINTENANCE("Maintenance", 19),

  /**
   * The base + fuel plan.
   */
  BASE_FUEL("BaseFuel", 20),

  /**
   * The pro plus + winter ops plan.
   */
  PRO_PLUS_WINTER_OPS("ProPlusWinterOps", 21),

  /**
   * The pro plus + car share plan.
   */
  PRO_PLUS_CAR_SHARE("ProPlusCarShare", 22),

  /**
   * The ProPlus + Wifi plan.
   */
  PRO_PLUS_WIFI("ProPlusWifi", 23),

  /**
   * The Base + Engine DTC plan.
   */
  BASE_ENGINE_DTC("BaseEngineDTC", 24),

  /**
   * The safety plan.
   */
  SAFETY("Safety", 25),

  /**
   * The Suspend Plan.
   */
  SUSPEND("Suspend", 99),

  /**
   * The Terminate Plan.
   */
  TERMINATE("Terminate", 9999),

  /**
   * The SB Plan.
   */
  SB("Sb", 99999),

  // Partner plans

  /**
   * Fuel BI Standard plan.
   */
  FUEL_BI_STANDARD("FuelBIStandard", 1000001),

  /**
   * Zendu Maintenance plan.
   */
  ZENDU_MAINT("ZenduMaint", 1000002),

  /**
   * D2GO Driver Challenge plan.
   */
  D2GO_DRIVER_CHALLENGE_STANDARD("D2GODriverChallengeStandard", 1000003),

  /**
   * Optimum Fleet Health rate plan.
   */
  OFH_MAINT_TRIAGE("OFHMaintTriage", 1000004),

  /**
   * Optimum Fleet Health rate plan.
   */
  OFH_MAINT_STAY_FIT("OFHMaintStayfit", 1000005),

  /**
   * R4Me Notify4Me Base rate plan.
   */
  R4ME_NOTIFY4ME_BASE("R4MeNotify4MeBase", 1000006),

  /**
   * R4Me Notify4Me Pro rate plan.
   */
  R4ME_NOTIFY4ME_PRO("R4MeNotify4MePro", 1000007),

  /**
   * R4Me Dispatch4 Me Base rate plan.
   */
  R4ME_DISPATCH4ME_BASE("R4MeDispatch4MeBase", 1000008),

  /**
   * R4Me Dispatch4Me Pro rate plan.
   */
  R4ME_DISPATCH4ME_PRO("R4MeDispatch4MePro", 1000009),

  /**
   * R4Me Optimization4Me Base rate plan.
   */
  R4ME_OPTIMIZATION4ME_BASE("R4MeOptimization4MeBase", 1000010),

  /**
   * R4Me Optimization4Me Pro rate plan.
   */
  R4ME_OPTIMIZATION4ME_PRO("R4MeOptimization4MePro", 1000011),

  /**
   * Zendu Maintenance Basic rate plan.
   */
  ZENDU_MAINT_BASIC("ZenduMaintBasic", 1000012),

  /**
   * Zendu Maintenance Pro rate plan.
   */
  ZENDU_MAINT_PRO("ZenduMaintPro", 1000013),

  /**
   * R4Me Basic.
   */
  R4ME_BASIC("R4MeBasic", 1000014),

  /**
   * Geotab Data Science Package.
   */
  GEOTAB_DATA_SCIENCE_PACKAGE("GeotabDataSciencePackage", 1000015),

  /**
   * Sawatchez EV.
   */
  SAWATCHEZ_EV("SawatchezEV", 1000016),

  /**
   * SurfsightON1.
   */
  SURFSIGHT_ON_1("SurfsightON1", 1000017);

  private final String name;
  private final int code;

  DevicePlan(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DevicePlan findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DevicePlan.class.getSimpleName(), DevicePlan.UNKNOWN);
      return UNKNOWN;
    }

    for (DevicePlan devicePlan : values()) {
      if (devicePlan.getName().equalsIgnoreCase(name.trim())) {
        return devicePlan;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DevicePlan.class.getSimpleName(), DevicePlan.UNKNOWN);
    return UNKNOWN;
  }
}
