package com.geotab.model.entity.device;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Device Plan information holding the Plan name and Billing level mapping.
 */
@Data
@Builder
@NoArgsConstructor
public class DevicePlanBillingInfo {

  /**
   * Device Plan Unknown.
   */
  public static final int DEVICE_PLAN_UNKNOWN = 0;

  /**
   * Device Plan ProPlus.
   */
  public static final int DEVICE_PLAN_PRO_PLUS = 10;

  /**
   * Device Plan ProPlusWinterOps.
   */
  public static final int DEVICE_PLAN_PRO_PLUS_WINTER_OPS = 21;

  /**
   * Device Plan ProPlusCarShare.
   */
  public static final int DEVICE_PLAN_PRO_PLUS_CAR_SHARE = 22;

  /**
   * Device Plan ProPlusWifi.
   */
  public static final int DEVICE_PLAN_PRO_PLUS_WIFI = 23;

  /**
   * Device Plan Suspend.
   */
  public static final int DEVICE_PLAN_SUSPEND = 99;

  /**
   * Device Plan Terminate.
   */
  public static final int DEVICE_PLAN_TERMINATE = 9999;

  /**
   * Device Plan Sb.
   */
  public static final int DEVICE_PLAN_SB = 99999;

  /**
   * Gets the Billing Level.
   */
  private Integer billingLevel;

  /**
   * Gets the name of the Device Plan name.
   */
  private String devicePlanName;

  @Builder
  public DevicePlanBillingInfo(Integer billingLevel, String devicePlanName) {
    this.billingLevel = billingLevel;
    this.devicePlanName = devicePlanName;
  }
}
