package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DtcClass implements HasName {

  /**
   * DTCClass 0 is unclassified.
   */
  @JsonEnumDefaultValue
  UNCLASSIFIED("Unclassified", 0),

  /**
   * DTCClass 1 matches the GTR module B Class A definition.
   */
  A("A", 1),

  /**
   * DTCClass 2 matches the GTR module B Class B1 definition.
   */
  B1("B1", 2),

  /**
   * DTCClass 3 matches the GTR module B Class B2 definition.
   */
  B2("B2", 3),

  /**
   * DTCClass 4 matches the GTR module B Class C Definition.
   */
  C("C", 4);

  private final String name;
  private final int code;

  DtcClass(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DtcClass findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DtcClass.class.getSimpleName(), DtcClass.UNCLASSIFIED);
      return UNCLASSIFIED;
    }

    for (DtcClass dtcClass : values()) {
      if (dtcClass.getName().equalsIgnoreCase(name.trim())) {
        return dtcClass;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DtcClass.class.getSimpleName(), DtcClass.UNCLASSIFIED);
    return UNCLASSIFIED;
  }
}
