/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.device;

import static java.lang.Boolean.FALSE;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO10 device. Additional properties can be seen in {@link GoCurveAuxiliary}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go10Builder")
public class Go10 extends GoCurveAuxiliary {

  /**
   * Enables or disables OBD alerts for the device. Default [False].
   */
  protected Boolean obdAlertEnabled;

  {
    setDeviceType(DeviceType.GO10);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO10_PRODUCT_ID;
    this.obdAlertEnabled = FALSE;
  }
}
