package com.geotab.model.entity.device;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The Geotab GO8 device. Additional properties can be seen in {@link GoCurveAuxiliary}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "go8Builder")
public class Go8 extends GoCurveAuxiliary {

  {
    setDeviceType(DeviceType.GO8);
  }

  @Override
  public void populateDefaults() {
    super.populateDefaults();
    this.productId = GO8_PRODUCT_ID;
  }
}
