package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum HosOption implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  OFF("OFF", 0),

  ON("ON", 1),

  AUTO("AUTO", 2);

  private final String name;
  private final int code;

  HosOption(String name, int code) {
    this.name = name;
    this.code = code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public int getCode() {
    return code;
  }
}
