/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.Id;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Information from the engine computer that can either be measurement data or fault code data. This inherited class
 * only consists of a diagnostics Id.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "basicDiagnosticBuilder")
public class BasicDiagnostic extends Diagnostic {

  public BasicDiagnostic(String id) {
    setId(new Id(id));
  }
}
