package com.geotab.model.entity.diagnostic;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DiagnosticType implements HasName {

  @JsonEnumDefaultValue
  NONE("None"),
  SID("Sid"),
  PID("Pid"),
  GO_DIAGNOSTIC("GoDiagnostic"),
  DATA_DIAGNOSTIC("DataDiagnostic"),
  SUSPECT_PARAMETER("SuspectParameter"),
  OBD_FAULT("ObdFault"),
  GO_FAULT("GoFault"),
  OBD_WWH_FAULT("ObdWwhFault"),
  PROPRIETARY_FAULT("ProprietaryFault"),
  LEGACY_FAULT("LegacyFault"),
  GMCCC_FAULT("GmcccFault"),
  BRP_FAULT("BrpFault"),
  AI_MODEL("AiModel"),
  LEVC_FAULT("LevcFault");

  private final String name;

  DiagnosticType(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DiagnosticType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DiagnosticType.class.getSimpleName(), DiagnosticType.NONE);
      return NONE;
    }

    for (DiagnosticType diagnosticType : values()) {
      if (diagnosticType.getName().equalsIgnoreCase(name.trim())) {
        return diagnosticType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DiagnosticType.class.getSimpleName(), DiagnosticType.NONE);
    return NONE;
  }
}
