/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.entity.controller.NoController;
import com.geotab.model.entity.enginetype.EngineTypeNone;
import com.geotab.model.entity.source.SourceGo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A diagnostic that originates from a Go Device.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "goDiagnosticBuilder")
public class GoDiagnostic extends DataDiagnostic {

  {
    setDiagnosticType(DiagnosticType.GO_DIAGNOSTIC);
    setController(NoController.getInstance());
    setEngineType(EngineTypeNone.getInstance());
    setSource(SourceGo.getInstance());
    setOffset(0D);
  }
}
