/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A diagnostic for a legacy manufacturer specific fault.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "legacyFaultDiagnosticBuilder")
public class LegacyFaultDiagnostic extends Diagnostic {

  {
    setDiagnosticType(DiagnosticType.LEGACY_FAULT);
  }
}
