/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A diagnostic for Geotab Devices that represents DBNull database value.
 */
@Data
public final class NoDiagnostic extends Diagnostic implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoDiagnostic INSTANCE = new NoDiagnostic();
  }

  public static final String NO_DIAGNOSTIC_ID = "NoDiagnosticId";
  public static final String NO_DIAGNOSTIC_NAME = "***Unassigned Diagnostic";

  private NoDiagnostic() {
    setId(new Id(NO_DIAGNOSTIC_ID));
    setName(NO_DIAGNOSTIC_NAME);
    setVersion(0L);
    setValidLoggingPeriod(ValidLoggingPeriod.NONE);
  }

  public static NoDiagnostic getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
