/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A diagnostic for an OBD fault.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "obdSaFaultDiagnosticBuilder")
public class ObdSaFaultDiagnostic extends Diagnostic {

  {
    setDiagnosticType(DiagnosticType.OBD_WWH_FAULT);
    setValidLoggingPeriod(ValidLoggingPeriod.NONE);
  }
}
