/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.entity.controller.NoController;
import com.geotab.model.entity.source.SourceJ1708;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A {@link SourceJ1708} Parameter Identifier.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "pidBuilder")
public class Pid extends DataDiagnostic {

  {
    setDiagnosticType(DiagnosticType.PID);
    setController(NoController.getInstance());
    setSource(SourceJ1708.getInstance());
    setOffset(0D);
  }
}
