/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.entity.source.SourceJ1708;
import com.geotab.model.entity.unitofmeasure.UnitOfMeasureNone;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A {@link SourceJ1708} Subsystem Identifier.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "sidBuilder")
public class Sid extends Diagnostic {

  {
    setDiagnosticType(DiagnosticType.SID);
    setValidLoggingPeriod(ValidLoggingPeriod.NONE);
    setUnitOfMeasure(UnitOfMeasureNone.getInstance());
    setIsLogGuaranteedOnEstimateError(false);
  }
}
