/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.diagnostic;

import com.geotab.model.entity.controller.NoController;
import com.geotab.model.entity.parametergroup.ParameterGroup;
import com.geotab.model.entity.source.SourceJ1939;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Suspect parameter diagnostic.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "suspectParameterBuilder")
public class SuspectParameter extends DataDiagnostic {

  /**
   * The parameter group.
   */
  private ParameterGroup parameterGroup;

  {
    setDiagnosticType(DiagnosticType.SUSPECT_PARAMETER);
    setController(NoController.getInstance());
    setSource(SourceJ1939.getInstance());
  }
}
