/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.driverchange;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.DriverEmbeddedSerializer;
import com.geotab.model.serialization.DriverFromIdDeserializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Information about timing of a {@link Driver} change.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class DriverChange extends EntityWithVersion {

  /**
   * The Driver associated with the change.
   */
  @JsonDeserialize(using = DriverFromIdDeserializer.class)
  @JsonSerialize(using = DriverEmbeddedSerializer.class)
  private Driver driver;

  /**
   * The Device associated with the change.
   */
  private Device device;

  /**
   * The DriverChangeType.
   */
  private DriverChangeType type;

  /**
   * The date and time of the driver change.
   */
  private LocalDateTime dateTime;
}
