/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An AnnotationLog is a comment that can be associated with a{@link DutyStatusLog}. The Driver is the author of the
 * {@link AnnotationLog}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class AnnotationLog extends EntityWithVersion {

  /**
   * The {@link DutyStatusLog} which this log belongs to.
   */
  private DutyStatusLog dutyStatusLog;

  /**
   * The User who created the log.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User driver;

  /**
   * The date and time the log was created.
   */
  private LocalDateTime dateTime;

  /**
   * The annotation text associated with the log.
   */
  private String comment;
}
