/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.Duration;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Driver Availability for Hours of Service regulations.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class DutyStatusAvailability extends Entity {

  /**
   * The list of {@link DutyStatusAvailabilityDuration}(s) for a driver.
   */
  private List<DutyStatusAvailabilityDuration> availabilities;

  /**
   * The Driver associated with the duty status availability.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User driver;

  /**
   * The duration left before rest break must be taken.
   */
  private Duration rest;

  /**
   * The duration left for driving.
   */
  private Duration driving;

  /**
   * The duration of total on-duty time left in a day.
   */
  private Duration cycle;

  /**
   * The duration of duty hours left.
   */
  private Duration duty;

  /**
   * The duration of workday left in a day. Workday is a consecutive window that begins with first on-duty.
   */
  private Duration workday;

  /**
   * Chronological array representing each day's On-duty time since beginning of cycle.
   */

  private List<DutyStatusRecap> recap;

  /**
   * Cycle available to the driver in the future.
   */
  private List<DutyStatusCycleAvailability> cycleAvailabilities;

  /**
   * The duration left before cycle rest must be taken.
   */
  private Duration cycleRest;

  /**
   * The duty hours left since Cycle Rest.
   */
  private Duration dutySinceCycleRest;

  /**
   * Gets or sets if 16 hour exemption is available.
   */
  @JsonProperty("is16HourExemptionAvailable")
  private Boolean is16HourExemptionAvailable;

  /**
   * Gets or sets if adverse driving exemption is available.
   */
  @JsonProperty("isAdverseDrivingExemptionAvailable")
  private Boolean isAdverseDrivingExemptionAvailable;

  /**
   * Gets or sets if off-duty deferral exemption is available.
   */
  @JsonProperty("isOffDutyDeferralExemptionAvailable")
  private Boolean isOffDutyDeferralExemptionAvailable;

  @Override
  public DutyStatusAvailability setId(Id id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Id getId() {
    return null;
  }
}
