/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DutyStatusOrigin implements HasName {

  /**
   * None.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),
  /**
   * Automatic recorded by device.
   */
  AUTOMATIC("Automatic", 1),

  /**
   * Manual entry by driver.
   */
  MANUAL("Manual", 2),

  /**
   * Other authenticated user.
   */
  OTHER_USER("OtherUser", 3),

  /**
   * Unassigned driver.
   */
  UNASSIGNED("Unassigned", 4);

  private final String name;
  private final int code;

  DutyStatusOrigin(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DutyStatusOrigin findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DutyStatusOrigin.class.getSimpleName(), DutyStatusOrigin.NONE);
      return NONE;
    }

    for (DutyStatusOrigin dutyStatusLogOrigin : values()) {
      if (dutyStatusLogOrigin.getName().equalsIgnoreCase(name.trim())) {
        return dutyStatusLogOrigin;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DutyStatusOrigin.class.getSimpleName(), DutyStatusOrigin.NONE);
    return NONE;
  }
}
