/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dutystatus;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum DutyStatusState implements HasName {

  /**
   * The none.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * The log is active and has been accepted by the driver.
   */
  ACTIVE("Active", 1),

  /**
   * The log is inactive. It has been removed or it is the modification history of a log.
   */
  INACTIVE("Inactive", 2),

  /**
   * The log is a pending edit request from another user.
   */
  REQUESTED("Requested", 3),

  /**
   * The log is a rejected edit request from another user.
   */
  REJECTED("Rejected", 4);

  private final String name;
  private final int code;

  DutyStatusState(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static DutyStatusState findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          DutyStatusState.class.getSimpleName(), DutyStatusState.NONE);
      return NONE;
    }

    for (DutyStatusState dutyStatusState : values()) {
      if (dutyStatusState.getName().equalsIgnoreCase(name.trim())) {
        return dutyStatusState;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, DutyStatusState.class.getSimpleName(), DutyStatusState.NONE);
    return NONE;
  }
}
