/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.dvirlog;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.group.Defect;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.DVIRDefectDeserializer;
import com.geotab.model.serialization.EntityAsIdSerializer;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A DVIRDefect is a Defect that can be associated with a {@link DVIRLog}. It contains repair information such as repair
 * DateTime, repair {@link User}, and {@link RepairStatusType}. DVIRDefect also consists a list of the {@link
 * DefectRemark}s which this DVIRDefect has. which can be used to store additional information for the defect.
 */
@Data
@NoArgsConstructor
@SuperBuilder
@JsonDeserialize(using = DVIRDefectDeserializer.class)
@SuppressWarnings("AbbreviationAsWordInName")
public class DVIRDefect extends Entity {

  /**
   * The {@link DefectRemark}s which this DVIRDefect has.s which this DVIRDefect has.
   */
  private List<DefectRemark> defectRemarks;

  /**
   * The {@link Defect} which this DVIRDefect belongs to.
   */
  private Defect defect;

  /**
   * The {@link User} who repaired the DVIRDefect.
   */
  @JsonSerialize(using = EntityAsIdSerializer.class)
  private User repairUser;

  /**
   * The date and time the DVIRDefect was repaired.
   */
  private LocalDateTime repairDateTime;

  /**
   * The {@link RepairStatusType} of this DVIRDefect.
   */
  private RepairStatusType repairStatus;
}
